#ifdef PRECOMPILEDHEADERS
	#include "Tactical All.h"
#else
	#include "sgp.h"
	#include "Debug Control.h"
	#include "expat.h"
	#include "XML.h"
	#include "Interface.h"
	#include "legion cfg.h"
	#include "Soldier Profile.h"
#endif
#ifdef LEGION2
struct
{
	PARSE_STAGE	curElement;

	CHAR8		szCharData[MAX_CHAR_DATA_LENGTH+1];
	ITEMS_NAMES_VALUES	curItemsNames;
	ITEMS_NAMES_VALUES *	curArray;

	UINT32			maxArraySize;
	UINT32			curIndex;
	UINT32			currentDepth;
	UINT32			maxReadDepth;
	//CHAR16 gzMercNames[MAX_ENEMY_NAMES_CHARS];
}
typedef itemNamesParseData;

BOOLEAN ItemName_TextOnly;

static void XMLCALL
itemNamesStartElementHandle(void *userData, const XML_Char *name, const XML_Char **atts)
{
	itemNamesParseData * pData = (itemNamesParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //are we reading this element?
	{
		if(strcmp(name, "ITEMS_NAMES") == 0 && pData->curElement == ELEMENT_NONE)
		{
			pData->curElement = ELEMENT_LIST;

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(strcmp(name, "ITEM") == 0 && pData->curElement == ELEMENT_LIST)
		{
			pData->curElement = ELEMENT;

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(pData->curElement == ELEMENT &&
			   (strcmp(name, "uiIndex") == 0 ||
			    strcmp(name, "ItemIndex") == 0 ||
				strcmp(name, "szItemName") == 0 ||
				strcmp(name, "szLongItemName") == 0 ||
				strcmp(name, "szItemDesc") == 0 ||
				strcmp(name, "szBRName") == 0 ||
				strcmp(name, "szBRDesc") == 0 
				))
		{
			pData->curElement = ELEMENT_PROPERTY;

			pData->maxReadDepth++; //we are not skipping this element
		}

		pData->szCharData[0] = '\0';
	}

	pData->currentDepth++;

}

static void XMLCALL
itemNamesCharacterDataHandle(void *userData, const XML_Char *str, int len)
{
	itemNamesParseData * pData = (itemNamesParseData *)userData;

	if( (pData->currentDepth <= pData->maxReadDepth) &&
		(strlen(pData->szCharData) < MAX_CHAR_DATA_LENGTH)
	){
		strncat(pData->szCharData,str,__min((unsigned int)len,MAX_CHAR_DATA_LENGTH-strlen(pData->szCharData)));
	}
}


static void XMLCALL
itemNamesEndElementHandle(void *userData, const XML_Char *name)
{
	itemNamesParseData * pData = (itemNamesParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) 
	{
		if(strcmp(name, "ITEMS_NAMES") == 0)
		{
			pData->curElement = ELEMENT_NONE;
		}
		else if(strcmp(name, "ITEM") == 0)
		{
			pData->curElement = ELEMENT_LIST;	
			
			if (!ItemName_TextOnly)
				{
					if ( pData->curItemsNames.ItemIndex > -1 )
					{
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szItemName, pData->curItemsNames.szItemName);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szLongItemName, pData->curItemsNames.szLongItemName);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szItemDesc, pData->curItemsNames.szItemDesc);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szBRName, pData->curItemsNames.szBRName);
									
						ItemName[pData->curItemsNames.uiIndex].ItemIndex = pData->curItemsNames.ItemIndex;
						//ItemName[pData->curItemsNames.uiIndex].uiIndex = pData->curItemsNames.uiIndex;
					}
				}
				else
				{
					if ( pData->curItemsNames.ItemIndex > -1 )
					{
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szItemName, pData->curItemsNames.szItemName);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szLongItemName, pData->curItemsNames.szLongItemName);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szItemDesc, pData->curItemsNames.szItemDesc);
						wcscpy(ItemName[pData->curItemsNames.uiIndex].szBRName, pData->curItemsNames.szBRName);
					}
				}		
		
		}
		else if(strcmp(name, "uiIndex") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curItemsNames.uiIndex	= (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "ItemIndex") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curItemsNames.ItemIndex	= (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "szItemName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curItemsNames.szItemName, sizeof(pData->curItemsNames.szItemName)/sizeof(pData->curItemsNames.szItemName[0]) );
			pData->curItemsNames.szItemName[sizeof(pData->curItemsNames.szItemName)/sizeof(pData->curItemsNames.szItemName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szLongItemName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curItemsNames.szLongItemName, sizeof(pData->curItemsNames.szLongItemName)/sizeof(pData->curItemsNames.szLongItemName[0]) );
			pData->curItemsNames.szLongItemName[sizeof(pData->curItemsNames.szLongItemName)/sizeof(pData->curItemsNames.szLongItemName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szItemDesc") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curItemsNames.szItemDesc, sizeof(pData->curItemsNames.szItemDesc)/sizeof(pData->curItemsNames.szItemDesc[0]) );
			pData->curItemsNames.szItemDesc[sizeof(pData->curItemsNames.szItemDesc)/sizeof(pData->curItemsNames.szItemDesc[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szBRName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curItemsNames.szBRName, sizeof(pData->curItemsNames.szBRName)/sizeof(pData->curItemsNames.szBRName[0]) );
			pData->curItemsNames.szBRName[sizeof(pData->curItemsNames.szBRName)/sizeof(pData->curItemsNames.szBRName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szBRDesc") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curItemsNames.szBRDesc, sizeof(pData->curItemsNames.szBRDesc)/sizeof(pData->curItemsNames.szBRDesc[0]) );
			pData->curItemsNames.szBRDesc[sizeof(pData->curItemsNames.szBRDesc)/sizeof(pData->curItemsNames.szBRDesc[0]) - 1] = '\0';
		}
		pData->maxReadDepth--;
	}
	pData->currentDepth--;
}




BOOLEAN ReadInItemsNames(STR fileName, BOOLEAN localizedVersion)
{
	HWFILE		hFile;
	UINT32		uiBytesRead;
	UINT32		uiFSize;
	CHAR8 *		lpcBuffer;
	XML_Parser	parser = XML_ParserCreate(NULL);

	itemNamesParseData pData;

	DebugMsg(TOPIC_JA2, DBG_LEVEL_3, "Loading ItemsNames.xml" );

	ItemName_TextOnly = localizedVersion;
	
	// Open file
	hFile = FileOpen( fileName, FILE_ACCESS_READ, FALSE );
	if ( !hFile )
		return( localizedVersion );

	uiFSize = FileGetSize(hFile);
	lpcBuffer = (CHAR8 *) MemAlloc(uiFSize+1);

	//Read in block
	if ( !FileRead( hFile, lpcBuffer, uiFSize, &uiBytesRead ) )
	{
		MemFree(lpcBuffer);
		return( FALSE );
	}

	lpcBuffer[uiFSize] = 0; //add a null terminator

	FileClose( hFile );


	XML_SetElementHandler(parser, itemNamesStartElementHandle, itemNamesEndElementHandle);
	XML_SetCharacterDataHandler(parser, itemNamesCharacterDataHandle);


	memset(&pData,0,sizeof(pData));
	XML_SetUserData(parser, &pData);


	if(!XML_Parse(parser, lpcBuffer, uiFSize, TRUE))
	{
		CHAR8 errorBuf[511];

		sprintf(errorBuf, "XML Parser Error in ItemsNames.xml: %s at line %d", XML_ErrorString(XML_GetErrorCode(parser)), XML_GetCurrentLineNumber(parser));
		LiveMessage(errorBuf);

		MemFree(lpcBuffer);
		return FALSE;
	}

	MemFree(lpcBuffer);


	XML_ParserFree(parser);


	return( TRUE );
}
#endif